/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.prop;

import cds.aladin.prop.PropAction;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Prop {
    private String id;
    private JComponent label;
    private JComponent widget;
    private String help;
    private PropAction action;
    private PropAction resume;

    public String getId() {
        return this.id;
    }

    public JComponent getLabel() {
        return this.label;
    }

    public JComponent getWidget() {
        return this.widget;
    }

    public String getHelp() {
        return this.help;
    }

    public int apply() {
        if (this.action == null) {
            return -1;
        }
        return this.action.action();
    }

    public void resume() {
        if (this.resume == null) {
            return;
        }
        if (this.widget.hasFocus()) {
            return;
        }
        this.resume.action();
    }

    public static Prop propFactory(String id, Object label, String help, Object widget, PropAction resumeAction, PropAction applyAction) {
        Prop p = new Prop();
        p.id = id;
        p.resume = resumeAction;
        if (label instanceof String) {
            JLabel lab = new JLabel((String)label);
            lab.setFont(lab.getFont().deriveFont(1));
            p.label = lab;
        } else {
            p.label = (JComponent)label;
        }
        p.widget = widget instanceof String ? new JLabel((String)widget) : (JComponent)widget;
        p.help = help;
        p.action = applyAction;
        return p;
    }

    public static void remove(Vector<Prop> propList, String id) {
        for (Prop p : propList) {
            if (!id.equals(p.getId())) continue;
            propList.remove(p);
            return;
        }
    }
}

